<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/GestoreFile.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/GeneratoreSiteMap.php";
    include "../classi/GestoreImpostazioni.php";
    include "../classi/GestoreHtaccess.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/GeneratoreSiteMapGeecom.php";

    session_start();
    
    // i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    $impostazioniLingue  = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue", 1);
    $gestoreImpostazioni = new GestoreImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    }

    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomCms = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    switch ($operazione) {
        case 'aggiornaCampoTabella':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $tabella = filter_input(INPUT_GET,"tabella",FILTER_SANITIZE_ADD_SLASHES);
            $id      = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $campo   = filter_input(INPUT_GET,"campo",FILTER_SANITIZE_ADD_SLASHES);
            $valore  = filter_input(INPUT_GET,"valore",FILTER_SANITIZE_ADD_SLASHES);
            
            if($tabella!="geec_utenti") { // la tabella utenti non può essere aggiornata in questo modo per evitare problemi di sicurezza
                $query = "UPDATE $tabella SET $campo='$valore' WHERE id=$id";
                $geecomDb->eseguiQueryScrittura($query);
                echo "ok";
            }
            else {
                echo "Operazione non permessa!";
            }
            break;
        case 'aggiornaImpostazioniGenerali':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $titoloEsteso      = filter_input(INPUT_POST,"titoloEsteso",FILTER_SANITIZE_ADD_SLASHES);
            $titoloSito        = filter_input(INPUT_POST,"titoloSito",FILTER_SANITIZE_ADD_SLASHES);
            $descrizioneSito   = filter_input(INPUT_POST,"descrizioneSito",FILTER_SANITIZE_ADD_SLASHES);
            $urlSito           = filter_input(INPUT_POST,"urlSito",FILTER_SANITIZE_ADD_SLASHES);
            $manutenzione      = filter_input(INPUT_POST,"manutenzione",FILTER_SANITIZE_ADD_SLASHES);
            $paginaManutenzione = filter_input(INPUT_POST,"paginaManutenzione",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geecB_impostazioni SET titoloEsteso='$titoloEsteso', titoloSito='$titoloSito', descrizioneSito='$descrizioneSito', urlSito='$urlSito', manutenzione='$manutenzione', paginaManutenzione='$paginaManutenzione' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=200");
            break;
        case 'aggiornaProfiliSocial':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $facebook  = filter_input(INPUT_POST,"facebook",FILTER_SANITIZE_ADD_SLASHES);
            $instagram = filter_input(INPUT_POST,"instagram",FILTER_SANITIZE_ADD_SLASHES);
            $twitter   = filter_input(INPUT_POST,"twitter",FILTER_SANITIZE_ADD_SLASHES);
            $linkedin  = filter_input(INPUT_POST,"linkedin",FILTER_SANITIZE_ADD_SLASHES);
            $youtube   = filter_input(INPUT_POST,"youtube",FILTER_SANITIZE_ADD_SLASHES);
            $patreon   = filter_input(INPUT_POST,"patreon",FILTER_SANITIZE_ADD_SLASHES);
            $ticToc    = filter_input(INPUT_POST,"ticToc",FILTER_SANITIZE_ADD_SLASHES);
            $whatsapp  = filter_input(INPUT_POST,"whatsapp",FILTER_SANITIZE_ADD_SLASHES);
            $mostraChatWhatsapp = filter_input(INPUT_POST,"mostraChatWhatsapp",FILTER_SANITIZE_ADD_SLASHES);
            $telegram           = filter_input(INPUT_POST,"telegram",FILTER_SANITIZE_URL);
            $mostraChatTelegram = filter_input(INPUT_POST,"mostraChatTelegram",FILTER_SANITIZE_ADD_SLASHES);
            
            $queryAggiornamentoDati ="UPDATE geec_profiliSocial SET facebook='$facebook', twitter='$twitter', linkedin='$linkedin', youtube='$youtube', patreon='$patreon', ticToc='$ticToc', instagram='$instagram', whatsapp='$whatsapp', mostraChatWhatsapp='$mostraChatWhatsapp', telegram='$telegram', mostraChatTelegram='$mostraChatTelegram'  WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoDati);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=210");
            break;
        case 'aggiornaImpostazioniLingue':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $impostazioniItaliano   = $geecomDb->escapeString($_POST['impostazioniItaliano']);
            $menuItaliano           = $geecomDb->escapeString($_POST['menuItaliano']);
            $menuSecondarioItaliano = isset($_POST['menuSecondarioTedesco']) ? $geecomDb->escapeString($_POST['menuSecondarioItaliano']) : 0;
            $paginaBlogItaliano     = $geecomDb->escapeString($_POST['paginaBlogItaliano']);
            $homePage               = $geecomDb->escapeString($_POST['homePageItaliano']);
            
            $impostazioniInglese   = $geecomDb->escapeString($_POST['impostazioniInglese']);
            $menuInglese           = $geecomDb->escapeString($_POST['menuInglese']);
            $menuSecondarioInglese = isset($_POST['menuSecondarioTedesco']) ? $geecomDb->escapeString($_POST['menuSecondarioInglese']) : 0;
            $paginaBlogInglese     = $geecomDb->escapeString($_POST['paginaBlogInglese']);
            $homePageEn            = $geecomDb->escapeString($_POST['homePageInglese']);

            $impostazioniTedesco   = $geecomDb->escapeString($_POST['impostazioniTedesco']);
            $menuTedesco           = $geecomDb->escapeString($_POST['menuTedesco']);
            $menuSecondarioTedesco = isset($_POST['menuSecondarioTedesco']) ? $geecomDb->escapeString($_POST['menuSecondarioTedesco']) : 0;
            $paginaBlogTedesco     = $geecomDb->escapeString($_POST['paginaBlogTedesco']);
            $homePageDe            = $geecomDb->escapeString($_POST['homePageTedesco']);

            $impostazioniFrancese   = $geecomDb->escapeString($_POST['impostazioniFrancese']);
            $menuFrancese           = $geecomDb->escapeString($_POST['menuFrancese']);
            $menuSecondarioFrancese = isset($_POST['menuSecondarioTedesco']) ? $geecomDb->escapeString($_POST['menuSecondarioFrancese']) : 0;
            $paginaBlogFrancese     = $geecomDb->escapeString($_POST['paginaBlogFrancese']);
            $homePageFr             = $geecomDb->escapeString($_POST['homePageFrancese']);
            
            $impostazioniSpagnolo   = $geecomDb->escapeString($_POST['impostazioniSpagnolo']);
            $menuSpagnolo           = $geecomDb->escapeString($_POST['menuSpagnolo']);
            $menuSecondarioSpagnolo = isset($_POST['menuSecondarioTedesco']) ? $geecomDb->escapeString($_POST['menuSecondarioSpagnolo']) : 0;
            $paginaBlogSpagnolo     = $geecomDb->escapeString($_POST['paginaBlogSpagnolo']);
            $homePageSp             = $geecomDb->escapeString($_POST['homePageSpagnolo']);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoLingue = "UPDATE geecB_impostazioniLingue SET impostazioniItaliano='$impostazioniItaliano', menuItaliano='$menuItaliano', menuSecondarioItaliano='$menuSecondarioItaliano', paginaBlogItaliano=$paginaBlogItaliano, impostazioniInglese='$impostazioniInglese', menuInglese='$menuInglese', menuSecondarioInglese='$menuSecondarioInglese', paginaBlogInglese=$paginaBlogInglese,
    impostazioniTedesco='$impostazioniTedesco', menuTedesco='$menuTedesco', menuSecondarioTedesco='$menuSecondarioTedesco', paginaBlogTedesco=$paginaBlogTedesco, impostazioniFrancese='$impostazioniFrancese', menuFrancese='$menuFrancese', menuSecondarioFrancese='$menuSecondarioFrancese', paginaBlogFrancese=$paginaBlogFrancese, impostazioniSpagnolo='$impostazioniSpagnolo', menuSpagnolo='$menuSpagnolo', 
    menuSecondarioSpagnolo='$menuSecondarioSpagnolo', paginaBlogSpagnolo=$paginaBlogSpagnolo WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoLingue);

            //aggiorno le impostazioni delle home (attualmente nella tabella impostazioni)
            $queryAggiornamentoImpostazioni = "UPDATE geecB_impostazioni SET homePage='$homePage', homePageEn='$homePageEn', homePageDe='$homePageDe', homePageFr='$homePageFr', homePageEs='$homePageSp' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioni);
            
            header("Location: $percorsoGeecomCms/impostazioni.php?status=500");
            break;
        case 'aggiornaImpostazioniFooter':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $idFooter              = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $lingua                = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaFooterSuperiore = $geecomDb->escapeString($_POST["attivaFooterSuperiore"]);
            $numeroColonne = $geecomDb->escapeString($_POST["numeroColonne"]);
            $colonna1 = $geecomDb->escapeString($_POST["colonna1"]);
            $colonna2 = $geecomDb->escapeString($_POST["colonna2"]);
            $colonna3 = $geecomDb->escapeString($_POST["colonna3"]);
            $colonna4 = $geecomDb->escapeString($_POST["colonna4"]);

            $titoloColonna1 = $geecomDb->escapeString($_POST["titoloColonna1"]);
            $titoloColonna2 = $geecomDb->escapeString($_POST["titoloColonna2"]);
            $titoloColonna3 = $geecomDb->escapeString($_POST["titoloColonna3"]);
            $titoloColonna4 = $geecomDb->escapeString($_POST["titoloColonna4"]);

            $testoAggiuntivoColonna1 = filter_input(INPUT_POST,"testoAggiuntivoColonna1", FILTER_SANITIZE_ADD_SLASHES);
            $testoAggiuntivoColonna2 = filter_input(INPUT_POST,"testoAggiuntivoColonna2", FILTER_SANITIZE_ADD_SLASHES);
            $testoAggiuntivoColonna3 = filter_input(INPUT_POST,"testoAggiuntivoColonna3", FILTER_SANITIZE_ADD_SLASHES);
            $testoAggiuntivoColonna4 = filter_input(INPUT_POST,"testoAggiuntivoColonna4", FILTER_SANITIZE_ADD_SLASHES);
            
            $coloreFooterInferiore = filter_input(INPUT_POST,"coloreFooterInferiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreFooterSuperiore = filter_input(INPUT_POST,"coloreFooterSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestiMenu       = filter_input(INPUT_POST,"coloreTestiMenu", FILTER_SANITIZE_ADD_SLASHES);

            $testo= str_replace("../immagini","immagini",$geecomDb->escapeString($_POST["testoFooter"]));

            $queryModificaFooter = "UPDATE geecB_footer SET attivaFooterSuperiore='$attivaFooterSuperiore', numeroColonne=$numeroColonne, colonna1=$colonna1, colonna2=$colonna2, colonna3=$colonna3, colonna4=$colonna4, titoloColonna1='$titoloColonna1', titoloColonna2='$titoloColonna2', titoloColonna3='$titoloColonna3', titoloColonna4='$titoloColonna4', testoAggiuntivoColonna1='$testoAggiuntivoColonna1', testoAggiuntivoColonna2='$testoAggiuntivoColonna2', testoAggiuntivoColonna3='$testoAggiuntivoColonna3', testoAggiuntivoColonna4='$testoAggiuntivoColonna4', testo='$testo', coloreFooterInferiore='$coloreFooterInferiore', coloreFooterSuperiore='$coloreFooterSuperiore', coloreTestiMenu='$coloreTestiMenu' WHERE id=$idFooter";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=240&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniBarraMenu':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $sfondoBarraMenu      = filter_input(INPUT_POST,"sfondoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraMenu = filter_input(INPUT_POST,"coloreTestoBarraMenu", FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaBarraMenu = "UPDATE geec_configurazioniAspetto SET sfondoBarraMenu='$sfondoBarraMenu', coloreTestoBarraMenu='$coloreTestoBarraMenu' WHERE selezionataCms='si'";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=330");
            break;
        case 'aggiornaImpostazioniBarraSuperiore':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $menuSecondario             = $geecomDb->escapeString($_POST['menuSecondario']);
            $mostraProfiliSocial        = $geecomDb->escapeString($_POST['mostraProfiliSocial']);
            $menuSceltaLingue           = filter_input(INPUT_POST, "menuSceltaLingue", FILTER_SANITIZE_ADD_SLASHES);
            $attivaBarraSuperiore       = filter_input(INPUT_POST, "attivaBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreBarraSuperiore       = filter_input(INPUT_POST, "coloreBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $coloreTestoBarraSuperiore  = filter_input(INPUT_POST, "coloreTestoBarraSuperiore", FILTER_SANITIZE_ADD_SLASHES);
            $idMenuSecondario           = filter_input(INPUT_POST, "idMenuSecondario", FILTER_SANITIZE_NUMBER_INT);
            $allineamentoMenuSecondario = filter_input(INPUT_POST,'allineamentoMenuSecondario',FILTER_SANITIZE_ADD_SLASHES);
            $mostraTestoBarraSuperiore  = $geecomDb->escapeString($_POST['mostraTestoBarraSuperiore']);
            $testoBarraSuperiore        = filter_input(INPUT_POST,'testoBarraSuperiore',FILTER_SANITIZE_ADD_SLASHES);
            $allineamentoTestoBarraSuperiore = filter_input(INPUT_POST,'allineamentoTestoBarraSuperiore',FILTER_SANITIZE_ADD_SLASHES);

            $queryModificaBarraMenu = "UPDATE geecB_impostazioni SET menuSecondario='$menuSecondario', idMenuSecondario=$idMenuSecondario, allineamentoMenuSecondario='$allineamentoMenuSecondario', mostraProfiliSocial='$mostraProfiliSocial', menuSceltaLingue='$menuSceltaLingue', attivaBarraSuperiore='$attivaBarraSuperiore', coloreBarraSuperiore='$coloreBarraSuperiore', coloreTestoBarraSuperiore='$coloreTestoBarraSuperiore', mostraTestoBarraSuperiore='$mostraTestoBarraSuperiore', testoBarraSuperiore='$testoBarraSuperiore', allineamentoTestoBarraSuperiore='$allineamentoTestoBarraSuperiore' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryModificaBarraMenu);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=340");
            break;
        case 'aggiornaTemplateEmail':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id         = filter_input(INPUT_POST,"id", FILTER_SANITIZE_NUMBER_INT);
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_MAGIC_QUOTES);
            $css        = filter_input(INPUT_POST,"css", FILTER_SANITIZE_MAGIC_QUOTES);
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_MAGIC_QUOTES);
            $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_MAGIC_QUOTES);

            $queryModificaFooter = "UPDATE geec_templateEmail SET nome='$nome', css='$css', corpoMail='$corpoMail', footerMail='$footerMail' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'creaTemplateEmail':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $nome       = filter_input(INPUT_POST,"nome", FILTER_SANITIZE_MAGIC_QUOTES);
            $css        = filter_input(INPUT_POST,"css", FILTER_SANITIZE_MAGIC_QUOTES);
            $corpoMail  = filter_input(INPUT_POST,"corpoMail", FILTER_SANITIZE_MAGIC_QUOTES);
            $footerMail = filter_input(INPUT_POST,"footerMail", FILTER_SANITIZE_MAGIC_QUOTES);

            $queryModificaFooter = "INSERT INTO geec_templateEmail VALUES(NULL,'$nome','$css','$corpoMail','$footerMail')";
            $geecomDb->eseguiQueryScrittura($queryModificaFooter);
            $id = $geecomDb->idUltimoElemento();
            header("Location: $percorsoGeecomCms/impostazioni.php?status=285&idTemplate=$id");
            break;
        case 'aggiornaImpostazioniInclusioni':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $inizioHead  = $geecomDb->escapeString($_POST['inizioHead']);
            $fineHead    = $geecomDb->escapeString($_POST['fineHead']);
            $inizioBody  = $geecomDb->escapeString($_POST['inizioBody']);
            $fineBody    = $geecomDb->escapeString($_POST['fineBody']);
            $footer      = $geecomDb->escapeString($_POST['inclusioneFooter']);
            $queryAggiornamentoPaginaContatti = "UPDATE geecB_inclusioni SET inizioHead='$inizioHead', fineHead='$fineHead', inizioBody='$inizioBody', fineBody='$fineBody', footer='$footer' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=250");
            break;
        case 'cambiaConfigurazioneAspetto':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id  = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $queryAzzeramentoImpostazioni = "UPDATE geec_configurazioniAspetto SET selezionataCms = 'no'";
            $geecomDb->eseguiQueryScrittura($queryAzzeramentoImpostazioni); 
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET selezionataCms = 'si' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            echo "ok";
            break;
        case 'cambiaFontConfigurazioneAspetto':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id         = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $linkFont   = filter_input(INPUT_POST,"linkFont",FILTER_SANITIZE_ADD_SLASHES);
            $fontTesti  = filter_input(INPUT_POST,"fontTesti",FILTER_SANITIZE_ADD_SLASHES);
            $fontIntestazioni = filter_input(INPUT_POST,"fontIntestazioni",FILTER_SANITIZE_ADD_SLASHES);
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET linkFont='$linkFont', fontTesti='$fontTesti', fontIntestazioni='$fontIntestazioni' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=320");
            break;
        case 'cambiaClassiColonne':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id                    = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $attivaColonnaSinistra = filter_input(INPUT_POST,"attivaColonnaSinistra",FILTER_SANITIZE_ADD_SLASHES);
            $colonnaSinistra       = filter_input(INPUT_POST,"colonnaSinistra",FILTER_SANITIZE_ADD_SLASHES);
            $colonnaCentrale       = filter_input(INPUT_POST,"colonnaCentrale",FILTER_SANITIZE_ADD_SLASHES);
            $attivaColonnaDestra   = filter_input(INPUT_POST,"attivaColonnaDestra",FILTER_SANITIZE_ADD_SLASHES);
            $colonnaDestra         = filter_input(INPUT_POST,"colonnaDestra",FILTER_SANITIZE_ADD_SLASHES);
            $aspettoComponentiLaterali = filter_input(INPUT_POST,"aspettoComponentiLaterali",FILTER_SANITIZE_ADD_SLASHES);
            
            $querySelezioneNuovaConfigurazione = "UPDATE geec_configurazioniAspetto SET attivaColonnaSinistra='$attivaColonnaSinistra', colonnaSinistra='$colonnaSinistra', colonnaCentrale='$colonnaCentrale', attivaColonnaDestra='$attivaColonnaDestra', colonnaDestra='$colonnaDestra', aspettoComponentiLaterali='$aspettoComponentiLaterali' WHERE id=$id";
            $geecomDb->eseguiQueryScrittura($querySelezioneNuovaConfigurazione);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=325");
            break;
        case 'aggiornaColoriConfigurazione':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $query = "UPDATE geec_configurazioniAspetto SET colorePrimario='$colorePrimario', coloreSecondario='$coloreSecondario', coloreSuccess='$coloreSuccess', coloreInfo='$coloreInfo', coloreLight='$coloreLight', coloreDark='$coloreDark', coloreWarning='$coloreWarning', coloreDanger='$coloreDanger',colorePrimarioHover='$colorePrimarioHover', coloreSecondarioHover='$coloreSecondarioHover', coloreSuccessHover='$coloreSuccessHover', coloreInfoHover='$coloreInfoHover', coloreLightHover='$coloreLightHover', coloreDarkHover='$coloreDarkHover', coloreWarningHover='$coloreWarningHover', coloreDangerHover='$coloreDangerHover', colorePrimarioActive='$colorePrimarioActive', coloreSecondarioActive='$coloreSecondarioActive', coloreSuccessActive='$coloreSuccessActive', coloreInfoActive='$coloreInfoActive', coloreLightActive='$coloreLightActive', coloreDarkActive='$coloreDarkActive', coloreWarningActive='$coloreWarningActive', coloreDangerActive='$coloreDangerActive' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);

            header("Location: $percorsoGeecomCms/impostazioni.php?status=310");
            break;        
        case 'aggiornaBreakingPointConfigurazione':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $id                     = filter_input(INPUT_POST, "id", FILTER_SANITIZE_NUMBER_INT);
            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointXl", FILTER_SANITIZE_ADD_SLASHES);
            $query = "UPDATE geec_configurazioniAspetto SET breakingPointsXs='$breakingPointsXs', breakingPointsMd='$breakingPointsMd', breakingPointsLg='$breakingPointsLg', breakingPointsXl='$breakingPointsXl' WHERE id=$id";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=310");
            break;
        case 'clonaConfigurazione':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $precendenteConfigurazioneColore = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataCms");
            
            // per prima cosatutte le configurazioni vengono impostate a no
            $query = "UPDATE geec_configurazioniAspetto SET selezionataCms='no'";
            $geecomDb->eseguiQueryLettura($query);
            
            $sfondoBarraMenu        = filter_input(INPUT_POST,'sfondoBarraMenu',FILTER_SANITIZE_MAGIC_QUOTES);
            $coloreTestoBarraMenu   = filter_input(INPUT_POST,'coloreTestoBarraMenu',FILTER_SANITIZE_MAGIC_QUOTES);

            $linkFont               = filter_input(INPUT_POST,'linkFont',FILTER_SANITIZE_MAGIC_QUOTES);
            $fontIntestazioni       = filter_input(INPUT_POST,'fontIntestazioni',FILTER_SANITIZE_MAGIC_QUOTES);
            $fontTesti              = filter_input(INPUT_POST,'fontTesti',FILTER_SANITIZE_MAGIC_QUOTES);

            $nome                   = filter_input(INPUT_POST, "nome", FILTER_SANITIZE_ADD_SLASHES);
            $descrizione            = filter_input(INPUT_POST, "note", FILTER_SANITIZE_MAGIC_QUOTES);
            $colorePrimario         = filter_input(INPUT_POST, "colorePrimario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondario       = filter_input(INPUT_POST, "coloreSecondario", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccess          = filter_input(INPUT_POST, "coloreSuccess", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfo             = filter_input(INPUT_POST, "coloreInfo", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLight            = filter_input(INPUT_POST, "coloreLight", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDark             = filter_input(INPUT_POST, "coloreDark", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarning          = filter_input(INPUT_POST, "coloreWarning", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDanger             = filter_input(INPUT_POST, "coloreDanger", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioHover    = filter_input(INPUT_POST, "colorePrimarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioHover  = filter_input(INPUT_POST, "coloreSecondarioHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessHover     = filter_input(INPUT_POST, "coloreSuccessHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoHover        = filter_input(INPUT_POST, "coloreInfoHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightHover       = filter_input(INPUT_POST, "coloreLightHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkHover        = filter_input(INPUT_POST, "coloreDarkHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningHover        = filter_input(INPUT_POST, "coloreWarningHover", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerHover        = filter_input(INPUT_POST, "coloreDangerHover", FILTER_SANITIZE_ADD_SLASHES);

            $colorePrimarioActive   = filter_input(INPUT_POST, "colorePrimarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSecondarioActive = filter_input(INPUT_POST, "coloreSecondarioActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreSuccessActive    = filter_input(INPUT_POST, "coloreSuccessActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreInfoActive       = filter_input(INPUT_POST, "coloreInfoActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreLightActive      = filter_input(INPUT_POST, "coloreLightActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDarkActive       = filter_input(INPUT_POST, "coloreDarkActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreWarningActive    = filter_input(INPUT_POST, "coloreWarningActive", FILTER_SANITIZE_ADD_SLASHES);
            $coloreDangerActive     = filter_input(INPUT_POST, "coloreDangerActive", FILTER_SANITIZE_ADD_SLASHES);

            $breakingPointsXs       = filter_input(INPUT_POST, "breakingPointsXs", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsMd       = filter_input(INPUT_POST, "breakingPointsMd", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsLg       = filter_input(INPUT_POST, "breakingPointsLg", FILTER_SANITIZE_ADD_SLASHES);
            $breakingPointsXl       = filter_input(INPUT_POST, "breakingPointsXl", FILTER_SANITIZE_ADD_SLASHES);
            
            $attivaColonnaSinistra  = filter_input(INPUT_POST, "attivaColonnaSinistra", FILTER_SANITIZE_ADD_SLASHES);
            $colonnaSinistra        = filter_input(INPUT_POST, "colonnaSinistra", FILTER_SANITIZE_ADD_SLASHES);
            $colonnaCentrale        = filter_input(INPUT_POST, "colonnaCentrale", FILTER_SANITIZE_ADD_SLASHES);
            $attivaColonnaDestra    = filter_input(INPUT_POST, "attivaColonnaDestra", FILTER_SANITIZE_ADD_SLASHES);
            $colonnaDestra          = filter_input(INPUT_POST, "colonnaDestra", FILTER_SANITIZE_ADD_SLASHES);
            $aspettoComponentiLaterali = filter_input(INPUT_POST, "aspettoComponentiLaterali", FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "INSERT INTO `geec_configurazioniAspetto` (`id`, `nome`, `descrizione`, `selezionataCms`, `selezionataAdmin`, `logo`, `logoMobile`, `favicon`, `sfondoBarraMenu`, `coloreTestoBarraMenu`, `linkFont`, `fontIntestazioni`, `fontTesti`, `colorePrimario`, `coloreSecondario`, `coloreSuccess`, `coloreInfo`, `coloreLight`, `coloreDark`, `coloreWarning`, `coloreDanger`, `colorePrimarioHover`, `coloreSecondarioHover`, `coloreSuccessHover`, `coloreInfoHover`, `coloreLightHover`, `coloreDarkHover`, `coloreWarningHover`, `coloreDangerHover`, `colorePrimarioActive`, `coloreSecondarioActive`, `coloreSuccessActive`, `coloreInfoActive`, `coloreLightActive`, `coloreDarkActive`, `coloreWarningActive`, `coloreDangerActive`, `breakingPointsXs`, `breakingPointsMd`, `breakingPointsLg`, `breakingPointsXl`, `attivaColonnaSinistra`, `colonnaSinistra`, `colonnaCentrale`, `attivaColonnaDestra`, `colonnaDestra`,`aspettoComponentiLaterali`)"
                    . "VALUES(NULL,'$nome','$descrizione','si','no','{$precendenteConfigurazioneColore["logo"]}','{$precendenteConfigurazioneColore["logoMobile"]}','{$precendenteConfigurazioneColore["favicon"]}','$sfondoBarraMenu','$coloreTestoBarraMenu','$linkFont','$fontIntestazioni','$fontTesti','$colorePrimario', '$coloreSecondario', '$coloreSuccess', '$coloreInfo', '$coloreLight', '$coloreDark', '$coloreWarning', '$coloreDanger','$colorePrimarioHover', '$coloreSecondarioHover', '$coloreSuccessHover', '$coloreInfoHover', '$coloreLightHover', '$coloreDarkHover', '$coloreWarningHover', '$coloreDangerHover', '$colorePrimarioActive', '$coloreSecondarioActive', '$coloreSuccessActive', '$coloreInfoActive', '$coloreLightActive', '$coloreDarkActive', '$coloreWarningActive', '$coloreDangerActive', '$breakingPointsXs', '$breakingPointsMd', '$breakingPointsLg', '$breakingPointsXl', '$attivaColonnaSinistra', '$colonnaSinistra', '$colonnaCentrale', '$attivaColonnaDestra', '$colonnaDestra','$aspettoComponentiLaterali')";
            $geecomDb->eseguiQueryLettura($query);
            echo"ok";
            break;            
        case 'aggiornaImpostazioniCookie':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $idBarraCookie     = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $lingua            = filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES);
            $attivaBarraCookie = filter_input(INPUT_POST,"attivaBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $durataCookie      = filter_input(INPUT_POST,"durataCookie",FILTER_SANITIZE_NUMBER_INT);
            $testoBarraCookie  = filter_input(INPUT_POST,"testoBarraCookie",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteAccetto    = filter_input(INPUT_POST,"testoPulsanteAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteNonAccetto = filter_input(INPUT_POST,"testoPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $testoPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"testoPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $headCodiciCookie = filter_input(INPUT_POST,"headCodiciCookie",FILTER_SANITIZE_ADD_SLASHES);
            $fineBodyCookie   = filter_input(INPUT_POST,"fineBodyCookie",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteMaggioriInformazioni = filter_input(INPUT_POST,"mostraPulsanteMaggioriInformazioni",FILTER_SANITIZE_ADD_SLASHES);
            $mostraPulsanteNonAccetto   = filter_input(INPUT_POST,"mostraPulsanteNonAccetto",FILTER_SANITIZE_ADD_SLASHES);
            $paginaMaggioriInformazioni = filter_input(INPUT_POST,"paginaMaggioriImpostazioni",FILTER_SANITIZE_NUMBER_INT);
            $queryAggiornamentoCookie   = "UPDATE `geecB_leggeCookie` SET `attivaBarraCookie` = '$attivaBarraCookie', `durataCookie` = '$durataCookie', `testoBarraCookie` = '$testoBarraCookie', `headCodiciCookie` = '$headCodiciCookie', `fineBodyCookie` = '$fineBodyCookie', `testoPulsanteAccetto` = '$testoPulsanteAccetto', `testoPulsanteNonAccetto` = '$testoPulsanteNonAccetto', `testoPulsanteMaggioriInformazioni` = '$testoPulsanteMaggioriInformazioni', `mostraPulsanteNonAccetto` = '$mostraPulsanteNonAccetto', `mostraPulsanteMaggioriInformazioni` = '$mostraPulsanteMaggioriInformazioni', `paginaMaggioriInformazioni` = '$paginaMaggioriInformazioni' WHERE id = $idBarraCookie;";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoCookie);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=260&lingua=$lingua");
            break;
        case 'aggiornaImpostazioniRicerca':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $elementiPerPagina    = filter_input(INPUT_POST,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT);
            $rimuoviUltimaLettera = filter_input(INPUT_POST,"rimuoviUltimaLettera",FILTER_SANITIZE_ADD_SLASHES);
            $salvaRicercheUtenti  = filter_input(INPUT_POST,"salvaRicercheUtenti",FILTER_SANITIZE_ADD_SLASHES);
            $cercaContenutiPerTitolo          = filter_input(INPUT_POST,"cercaContenutiPerTitolo",FILTER_SANITIZE_ADD_SLASHES);
            $cercaContenutiPerMetaDescrizione = filter_input(INPUT_POST,"cercaContenutiPerMetaDescrizione",FILTER_SANITIZE_ADD_SLASHES);
            $cercaContenutiPerSottotitolo     = filter_input(INPUT_POST,"cercaContenutiPerSottotitolo",FILTER_SANITIZE_ADD_SLASHES);
            $cercaContenutiPerTesto           = filter_input(INPUT_POST,"cercaContenutiPerTesto",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerNome            = filter_input(INPUT_POST,"cercaProdottiPerNome",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerMetaDescrizione = filter_input(INPUT_POST,"cercaProdottiPerMetaDescrizione",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerTesto           = filter_input(INPUT_POST,"cercaProdottiPerTesto",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerTestoDettagli   = filter_input(INPUT_POST,"cercaProdottiPerTestoDettagli",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerMarca           = filter_input(INPUT_POST,"cercaProdottiPerMarca",FILTER_SANITIZE_ADD_SLASHES);
            $cercaProdottiPerModello         = filter_input(INPUT_POST,"cercaProdottiPerModello",FILTER_SANITIZE_ADD_SLASHES);
            $queryAggiornamentoMotoreRicerca = "UPDATE `geecB_impostazioniRicerca` SET `elementiPerPagina` = '$elementiPerPagina', `rimuoviUltimaLettera` = '$rimuoviUltimaLettera', `salvaRicercheUtenti` = '$salvaRicercheUtenti', `cercaContenutiPerTitolo` = '$cercaContenutiPerTitolo', `cercaContenutiPerMetaDescrizione` = '$cercaContenutiPerMetaDescrizione', `cercaContenutiPerSottotitolo` = '$cercaContenutiPerSottotitolo', `cercaContenutiPerTesto` = '$cercaContenutiPerTesto', `cercaProdottiPerNome` = '$cercaProdottiPerNome', `cercaProdottiPerMetaDescrizione` = '$cercaProdottiPerMetaDescrizione', `cercaProdottiPerTesto` = '$cercaProdottiPerTesto', `cercaProdottiPerTestoDettagli` = '$cercaProdottiPerTestoDettagli', `cercaProdottiPerMarca` = '$cercaProdottiPerMarca', `cercaProdottiPerModello` = '$cercaProdottiPerModello' WHERE `id` = 1;";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoMotoreRicerca);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=295");
            break;
        case 'aggiornaImpostazioniSEO':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $testoFile         = filter_input(INPUT_POST, "contenutoFileRobots",FILTER_SANITIZE_ADD_SLASHES);
            $attivaCache       = filter_input(INPUT_POST, "attivaCache",FILTER_SANITIZE_ADD_SLASHES);
            $ottimizzazioneUrl = filter_input(INPUT_POST, "ottimizzazioneUrl",FILTER_SANITIZE_ADD_SLASHES);
            $consentiIndicizzazione = filter_input(INPUT_POST, "consentiIndicizzazione",FILTER_SANITIZE_ADD_SLASHES);
            $generazioneMappa       = filter_input(INPUT_POST, "generazioneMappa",FILTER_SANITIZE_ADD_SLASHES);
            $generaMappeSeparatePerLingua = filter_input(INPUT_POST, "generaMappeSeparatePerLingua",FILTER_SANITIZE_ADD_SLASHES);
            
            $queryAggiornamentoPaginaContatti = "UPDATE geecB_impostazioni SET ottimizzazioneUrl='$ottimizzazioneUrl', attivaCache='$attivaCache', consentiIndicizzazione='$consentiIndicizzazione', generazioneMappa='$generazioneMappa', generaMappeSeparatePerLingua='$generaMappeSeparatePerLingua' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            
            $stringaCache = ($attivaCache=="si") ? GestoreHtaccess::stampaCodiceAttivaCache() : "";
            
            //scrivo il file htaccess
            $htaccess = fopen("../.htaccess", "w");
            if($impostazioni["reindirizzamentoHttps"]!="nessuno" && $ottimizzazioneUrl=="si") {
                fwrite($htaccess, GestoreHtaccess::htaccessHttpsESeo($datiProdottoGeecom["percorso"],$impostazioni["reindirizzamentoHttps"]).$stringaCache);
            }
            else if($impostazioni["reindirizzamentoHttps"]=="nessuno" && $impostazioni["ottimizzazioneUrl"]=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessSeo($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["reindirizzamentoHttps"]=="https") { 
                fwrite($htaccess, GestoreHtaccess::htaccesRedirectsHttps($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["reindirizzamentoHttps"]=="httpswww") { 
                fwrite($htaccess, GestoreHtaccess::htaccesRedirectsHttpsWWW($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($impostazioni["reindirizzamentoHttps"]=="nessuno" && $ottimizzazioneUrl=="no") {
                fwrite($htaccess, $stringaCache); // in questo caso stampa solo il valore di attiva cache dato che gli altri due valori sono impostati a no
            }
            fclose($htaccess);
            
            if($generazioneMappa=="Non generare") {
                
            }
            else if($generazioneMappa!="Genera singola mappa con tutti i contenuti" || $generaMappeSeparatePerLingua=="si") {                
                $nuovaMappa              = "indice-mappe.xml";
                $stringaDaRimpiazzare    = "mappa-sito.xml";
                $contenutoBaseFileRobots = "User-agent: *\nDisallow:\n\nSitemap: {$impostazioni["urlSito"]}/indice-mappe.xml";
            }
            else {
                $stringaDaRimpiazzare    = "indice-mappe.xml";
                $nuovaMappa              = "mappa-sito.xml";
                $contenutoBaseFileRobots = "User-agent: *\nDisallow:\n\nSitemap: {$impostazioni["urlSito"]}/mappa-sito.xml";
            }
            
            $file = fopen("../robots.txt", "w") or die("Errore nell'aprire il file robots.txt!");
            if(strlen($testoFile)==0) {
                fwrite($file, $contenutoBaseFileRobots);
            }
            else {
                $nuovoContenutoFIle = str_replace($stringaDaRimpiazzare, $nuovaMappa, $testoFile);
                fwrite($file, $nuovoContenutoFIle);
            }
            fclose($file);
            
            header("Location: $percorsoGeecomCms/impostazioni.php?status=270");
            break;
        case 'aggiornaMappeSito':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $generatoreSiteMapGeecom = new GeneratoreSiteMapGeecom($geecomDb,$impostazioni);
            
            $arrayMappe = [];
            if($impostazioni["generazioneMappa"]=="Genera singola mappa con tutti i contenuti" && $impostazioni["generaMappeSeparatePerLingua"]=="si") {
                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") {
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine-".substr($lingua,0,2).".xml");
                        
                        $tabelle  = [
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"pagina","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ],
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"articolo","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ]
                        ];

                        $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
                        if(isset($datiComponenteEcommerce["versione"])) { // se esiste il componente ecommerce viene cambiato l'ultimo elemento
                            array_push($tabelle,[
                                    "tabella"=>"geecEc_prodotti",
                                    "parametri"=>["tipoProdotto"=>"fisico","lingua"=>$lingua],
                                    "colonnaDataCreazione"=>"dataInserimento",
                                    "colonnaParametroLink"=>"alias"
                                ]);
                        }
                         
                        $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                    }
                }
            }
            else if($impostazioni["generazioneMappa"]=="Genera singola mappa con tutti i contenuti") {
                $tabelle  = [
                    [
                        "tabella"=>"geec_categorie",
                        "parametri"=>["tipo"=>"categoriaArticolo"],
                        "frequenza"=>"daily",
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ],
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"pagina"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ],
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"articolo"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ]
                ];
                                
                $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
                if(isset($datiComponenteEcommerce["versione"])) { // se esiste il componente ecommerce viene cambiato l'ultimo elemento
                    array_push($tabelle,[
                            "tabella"=>"geecEc_prodotti",
                            "parametri"=>["tipoProdotto"=>"fisico"],
                            "colonnaDataCreazione"=>"dataInserimento",
                            "colonnaParametroLink"=>"alias"
                        ]);
                }
                 
                $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                $generatoreSiteMapGeecom->salvaSuFile("../mappa-sito.xml");
            }
            if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine e articoli" && $impostazioni["generaMappeSeparatePerLingua"]=="si") {
                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") {
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine-". substr($lingua,0,2).".xml");
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli-".substr($lingua,0,2).".xml");

                        $tabelle  = [
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"pagina","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ]
                        ];

                        $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                        $generatoreSiteMapGeecom->salvaSuFile("../mappa-pagine-".substr($lingua,0,2).".xml");

                        $tabellaArticoli  = [
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"articolo","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ]
                        ];

                        $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaArticoli);
                        $generatoreSiteMapGeecom->salvaSuFile("../mappa-articoli-".substr($lingua,0,2).".xml");
                    }
                }
            }
            else if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine e articoli") {
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine.xml");
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli.xml");
                        
                $tabelle  = [
                    [
                        "tabella"=>"geec_categorie",
                        "parametri"=>["tipo"=>"categoriaArticolo"],
                        "frequenza"=>"daily",
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ],
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"pagina"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ]
                ];
                
                $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                $generatoreSiteMapGeecom->salvaSuFile("../mappa-pagine.xml");
                
                $tabellaArticoli  = [
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"articolo"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ]
                ];
                
                $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaArticoli);
                $generatoreSiteMapGeecom->salvaSuFile("../mappa-articoli.xml");
            }
            else if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine, articoli e prodotti") {
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine.xml");
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli.xml");
                array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-prodotti.xml");
                
                $tabelle  = [
                    [
                        "tabella"=>"geec_categorie",
                        "parametri"=>["tipo"=>"categoriaArticolo"],
                        "frequenza"=>"daily",
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ],
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"pagina"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ]
                ];
                
                $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                $generatoreSiteMapGeecom->salvaSuFile("../mappa-pagine.xml");
                
                $tabellaArticoli  = [
                    [
                        "tabella"=>"geecB_contenuti",
                        "parametri"=>["tipo"=>"articolo"],
                        "colonnaDataCreazione"=>"dataCreazione",
                        "colonnaParametroLink"=>"alias"
                    ]
                ];
                
                $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaArticoli);
                $generatoreSiteMapGeecom->salvaSuFile("../mappa-articoli.xml");
                                                
                $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
                if(isset($datiComponenteEcommerce["versione"])) { // se esiste il componente ecommerce viene cambiato l'ultimo elemento
                    $tabellaProdotti  = [
                        [
                            "tabella"=>"geecEc_prodotti",
                            "parametri"=>["tipoProdotto"=>"fisico"],
                            "colonnaDataCreazione"=>"dataInserimento",
                            "colonnaParametroLink"=>"alias"
                        ]
                    ];
                    
                    $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaProdotti);
                    $generatoreSiteMapGeecom->salvaSuFile("../mappa-prodotti.xml");
                }
            }
            else if($impostazioni["generazioneMappa"]=="Genera mappa separata per pagine, articoli e prodotti" && $impostazioni["generaMappeSeparatePerLingua"]=="si") {
                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") {
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-pagine-". substr($lingua,0,2).".xml");
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-articoli-".substr($lingua,0,2).".xml");
                        array_push($arrayMappe,$impostazioni["urlSito"]."/mappa-prodotti-".substr($lingua,0,2).".xml");
                        
                        $tabelle  = [
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"pagina","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ]
                        ];

                        $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabelle);
                        $generatoreSiteMapGeecom->salvaSuFile("../mappa-pagine-".substr($lingua,0,2).".xml");

                        $tabellaArticoli  = [
                            [
                                "tabella"=>"geecB_contenuti",
                                "parametri"=>["tipo"=>"articolo","linguaContenuto"=>$lingua],
                                "colonnaDataCreazione"=>"dataCreazione",
                                "colonnaParametroLink"=>"alias"
                            ]
                        ];

                        $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaArticoli);
                        $generatoreSiteMapGeecom->salvaSuFile("../mappa-articoli-".substr($lingua,0,2).".xml");
                        
                        $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
                        if(isset($datiComponenteEcommerce["versione"])) { // se esiste il componente ecommerce viene cambiato l'ultimo elemento
                            $tabellaProdotti  = [
                                [
                                    "tabella"=>"geecEc_prodotti",
                                    "parametri"=>["tipoProdotto"=>"fisico","lingua"=>$lingua],
                                    "colonnaDataCreazione"=>"dataInserimento",
                                    "colonnaParametroLink"=>"alias"
                                ]
                            ];

                            $generatoreSiteMapGeecom->creaSitemapDaDatabase($tabellaProdotti);
                            $generatoreSiteMapGeecom->salvaSuFile("../mappa-prodotti-".substr($lingua,0,2).".xml");
                        }
                    }
                }
            }
            
            $contenutoFileRobots = file_get_contents("../robots.txt");
            if(count($arrayMappe)>1){
                $generatoreSiteMapGeecom->creaIndiceSitemap($arrayMappe);
                $generatoreSiteMapGeecom->salvaSuFile("../indice-mappe.xml");
            }
            
            $date = date("Y-m-d H:i");
            $queryAggiornamentoUltimaModificaMappa = "UPDATE geecB_statistiche SET ultimoAggiornamentoSitemap = '$date'";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoUltimaModificaMappa);
            echo "ok";
            break;
        case 'aggiornaImpostazioniPrestazioni':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $ottimizzaImmaginiCaricate = filter_input(INPUT_POST, "ottimizzaImmaginiCaricate",FILTER_SANITIZE_ADD_SLASHES);
            $altezzaImmagine  = filter_input(INPUT_POST, "altezzaImmagine",FILTER_SANITIZE_NUMBER_INT);
            $generaThumbnail  = filter_input(INPUT_POST, "generaThumbnail",FILTER_SANITIZE_ADD_SLASHES);
            $altezzaThumbnail = filter_input(INPUT_POST, "altezzaThumbnail",FILTER_SANITIZE_NUMBER_INT);
            $comprimiCss      = filter_input(INPUT_POST, "comprimiCss",FILTER_SANITIZE_ADD_SLASHES);
            $comprimiJs       = filter_input(INPUT_POST, "comprimiJs",FILTER_SANITIZE_ADD_SLASHES);

            // aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecB_impostazioni SET ottimizzaImmaginiCaricate='$ottimizzaImmaginiCaricate', altezzaImmagine=$altezzaImmagine, generaThumbnail='$generaThumbnail', altezzaThumbnail=$altezzaThumbnail, comprimiCss='$comprimiCss', comprimiJs='$comprimiJs' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);

            $fileCssDaCompattare = array("../plugins/hamburger/hamburgers.min.css",
                                        "../plugins/OwlCarousel2/assets/owl.carousel.min.css",
                                        "../plugins/animate/animate.css",
                                        "../plugins/universal-parallax/universal-parallax.min.css",
                                        "../plugins/aos/aos.css",
                                        "../plugins/cocoen/css/cocoen.min.css",
                                        "../plugins/ekko-lightbox/ekko-lightbox.css");
            if($comprimiCss=="si") {
                $cssUnificato = new GestoreFile("../template/cssUnificato.css","");
                $cssUnificato->importaContenutoAltriFile($fileCssDaCompattare);
                $cssUnificato->minimizzaContenuto();
                $cssUnificato->salva();
            }

            $fileJavascriptDaCompattare = array("../template/js/animateHeader.js",
                                                "../template/js/ricercaFullScreen.js",
                                                "../template/js/accordion.js",
                                                "../plugins/hamburger/hamburgers.js",
                                                "../plugins/shave/shave.js",
                                                "../template/js/scrollOnTop.js");
            if($comprimiJs=="si") {
                $jsUnificato = new GestoreFile("../template/jsUnificato.js","");
                $jsUnificato->importaContenutoAltriFile($fileJavascriptDaCompattare);
                $jsUnificato->minimizzaContenuto();
                $jsUnificato->salva();
            }
            header("Location: $percorsoGeecomCms/impostazioni.php?status=275");
            break;
        case 'aggiornaImpostazioniAPI':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $attivaApi     = filter_input(INPUT_POST,"attivaApi",FILTER_SANITIZE_ADD_SLASHES);
            $emailApi      = filter_input(INPUT_POST,"emailApi",FILTER_SANITIZE_ADD_SLASHES);
            $idAppFacebook = filter_input(INPUT_POST,"idAppFacebook",FILTER_SANITIZE_ADD_SLASHES);
            $secretAppFacebook = filter_input(INPUT_POST,"secretAppFacebook",FILTER_SANITIZE_ADD_SLASHES);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoImpostazioniAPI = "UPDATE geecB_impostazioni SET attivaApi='$attivaApi', emailApi='$emailApi', idAppFacebook='$idAppFacebook', secretAppFacebook='$secretAppFacebook' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioniAPI);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=271");
            break;
        case 'aggiornaImpostazioniAspetto':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $aspettoSito            = filter_input(INPUT_POST,"aspettoSito",FILTER_SANITIZE_ADD_SLASHES);
            $azzeraMargineSuperiore = (isset($_POST["azzeraMargineSuperiore"]) && $_POST["azzeraMargineSuperiore"]=="si") ? "si" : "no";
                    
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoAspetto = "UPDATE geecB_impostazioni SET aspettoSito='$aspettoSito', azzeraMargineSuperiore='$azzeraMargineSuperiore' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoAspetto);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=312");
            break;
        case 'aggiornaImpostazioniSicurezza':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $reindirizzamentoHttps     = filter_input(INPUT_POST, "reindirizzamentoHttps",FILTER_SANITIZE_ADD_SLASHES);
            $disattivaTastoDestroMouse = filter_input(INPUT_POST, "disattivaTastoDestroMouse",FILTER_SANITIZE_ADD_SLASHES);
            $inviaMailLogin            = filter_input(INPUT_POST, "inviaMailLogin",FILTER_SANITIZE_ADD_SLASHES);
            $loginADueFasi             = filter_input(INPUT_POST, "loginADueFasi",FILTER_SANITIZE_ADD_SLASHES);
            
            $attivaFortino       = filter_input(INPUT_POST,"attivaFortino",FILTER_SANITIZE_ADD_SLASHES);
            $parolaChiaveFortino = filter_input(INPUT_POST,"parolaChiaveFortino",FILTER_SANITIZE_ADD_SLASHES);

            $filtraggioIP       = filter_input(INPUT_POST,"filtraggioIP",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPAmmessi = filter_input(INPUT_POST,"indirizziIPAmmessi",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPBannati = filter_input(INPUT_POST,"indirizziIPBannati",FILTER_SANITIZE_ADD_SLASHES);

            $filtraggioIPCommenti       = filter_input(INPUT_POST,"filtraggioIPCommenti",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPAmmessiCommenti = filter_input(INPUT_POST,"indirizziIPAmmessiCommenti",FILTER_SANITIZE_ADD_SLASHES);
            $indirizziIPBannatiCommenti = filter_input(INPUT_POST,"indirizziIPBannatiCommenti",FILTER_SANITIZE_ADD_SLASHES);

            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoPaginaContatti = "UPDATE geecB_impostazioni SET reindirizzamentoHttps='$reindirizzamentoHttps', disattivaTastoDestroMouse='$disattivaTastoDestroMouse', inviaMailLogin='$inviaMailLogin', loginADueFasi='$loginADueFasi', attivaFortino='$attivaFortino', parolaChiaveFortino='$parolaChiaveFortino', filtraggioIP='$filtraggioIP', indirizziIPAmmessi='$indirizziIPAmmessi', indirizziIPBannati='$indirizziIPBannati', filtraggioIPCommenti='$filtraggioIPCommenti', indirizziIPAmmessiCommenti='$indirizziIPAmmessiCommenti', indirizziIPBannatiCommenti='$indirizziIPBannatiCommenti' WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoPaginaContatti);
            
            $stringaCache = ($impostazioni["attivaCache"]=="si") ? GestoreHtaccess::stampaCodiceAttivaCache() : "";
                    
            //scrivo il file htaccess, in questo caso il valore di https viene preso dalla variabile qui sopra dato che potrebbe essere stato modificato
            $htaccess = fopen("../.htaccess", "w");
            if($reindirizzamentoHttps!="nessuno" && $impostazioni["ottimizzazioneUrl"]=="si") {
                fwrite($htaccess, GestoreHtaccess::htaccessHttpsESeo($datiProdottoGeecom["percorso"],$reindirizzamentoHttps).$stringaCache);
            }
            else if($reindirizzamentoHttps=="nessuno" && $impostazioni["ottimizzazioneUrl"]=="si") { 
                fwrite($htaccess, GestoreHtaccess::htaccessSeo($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($reindirizzamentoHttps=="https") { 
                fwrite($htaccess, GestoreHtaccess::htaccesRedirectsHttps($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($reindirizzamentoHttps=="httpswww") { 
                fwrite($htaccess, GestoreHtaccess::htaccesRedirectsHttpsWWW($datiProdottoGeecom["percorso"]).$stringaCache);
            }
            else if($reindirizzamentoHttps=="nessuno" && $ottimizzazioneUrl=="no") {
                fwrite($htaccess, $stringaCache); // in questo caso stampa solo il valore di attiva cache dato che gli altri due valori sono impostati a no
            }
            fclose($htaccess);
            
            header("Location: $percorsoGeecomCms/impostazioni.php?status=280");
        break;
        case 'aggiornaImpostazioniProdottiInstallati':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $percorsoCMS   = filter_input(INPUT_POST,'percorsoCMS',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAdmin = filter_input(INPUT_POST,'percorsoAdmin',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoAsk   = filter_input(INPUT_POST,'percorsoAsk',FILTER_SANITIZE_ADD_SLASHES);
            $percorsoDoc   = filter_input(INPUT_POST,'percorsoDoc',FILTER_SANITIZE_ADD_SLASHES);

            $queryAggiornamento = array();
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoCMS' WHERE nome LIKE 'CMS'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAdmin' WHERE nome LIKE 'Admin'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoAsk' WHERE nome LIKE 'Ask'";
            $queryAggiornamento[count($queryAggiornamento)] = "UPDATE geec_prodotti SET percorso='$percorsoDoc' WHERE nome LIKE 'Doc'";
            $geecomDb->eseguiInsiemeDiQuery($queryAggiornamento);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=290");
            break;
        
            header("Location: $percorsoGeecomCms/creaContenuto.php?id={$datiComponente["idPagina"]}&status=350");
            break;
        case 'modificaLogo':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET logo='$percorsoFoto' WHERE selezionataCms='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'aggiornaDimensioniLogo':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $altezzaLogo      = filter_input(INPUT_POST,"altezzaLogo",FILTER_SANITIZE_ADD_SLASHES);
            $larghezzaLogo    = filter_input(INPUT_POST,"larghezzaLogo",FILTER_SANITIZE_ADD_SLASHES);
            $altezzaLogoXl    = filter_input(INPUT_POST,"altezzaLogoXl",FILTER_SANITIZE_ADD_SLASHES);
            $larghezzaLogoXl  = filter_input(INPUT_POST,"larghezzaLogoXl",FILTER_SANITIZE_ADD_SLASHES);
            
            $query = "UPDATE geec_configurazioniAspetto SET altezzaLogo='$altezzaLogo', larghezzaLogo='$larghezzaLogo', altezzaLogoXl='$altezzaLogoXl', larghezzaLogoXl='$larghezzaLogoXl' WHERE selezionataCms='si'";
            $geecomDb->eseguiQueryScrittura($query);
            header("Location: $percorsoGeecomCms/impostazioni.php?status=350");
            break;
        case 'modificaFavicon':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml","image/x-icon","image/vnd.microsoft.icon");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_configurazioniAspetto SET favicon='$percorsoFoto' WHERE selezionataCms='si'";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaIconaApp':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            if($_FILES['file']['name']=="") { //se non c'è l'immagine percorsoFoto = vuoto
                $percorsoFoto ="";
                $percorsoThumbnail = "";
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif","image/svg+xml","image/x-icon");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    
                    //aggiorno le impostazioni con i dati passati in input
                    $queryAggiornamentoProdotto = "UPDATE geec_impostazioniApp SET icona512='$percorsoFoto' WHERE id=1";
                    $geecomDb->eseguiQueryScrittura($queryAggiornamentoProdotto);
                    echo $esitoUpload["percorso"];
                }
            }
            break;
        case 'modificaStileCss':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            if($_FILES['file']['name']=="") { //se non c'è il file no nfa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/css");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.css");
                if($esitoUpload["percorso"]=="") {
                    if($idContenuto==0) {
                        header("Location: ../creaContenuto.php?tipo&articolo&status=455&errore={$esitoUpload["errore"]}");
                    }
                    else {
                        header("Location: ../creaContenuto.php?id=$idContenuto&status=455&errore={$esitoUpload["errore"]}");
                    }
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'scaricaFileStileCss':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.css");
            readfile("../template/stile.css");
            break;
        case 'scaricaFileStilePhp':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            header("Content-type: text/plain");
            header("Content-disposition: attachment; filename = stile.php");
            readfile("../template/stile.php");
            break;
        case 'modificaStilePhp':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            if($_FILES['file']['name']=="") { //se non c'è il file no fa niente
                
            }
            else { //se c'è l'immagine viene salvata e inserita nel percorso foto
                $tipiFileAmmessi = array("text/plain","text/x-php");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../template", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile("stile.php");
                if($esitoUpload["percorso"]=="") {
                    echo $esitoUpload["errore"];
                    exit();
                }
                else {
                    echo "ok";
                }
            }
            break;
        case 'incrementaClickSlide':
            $id = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $gestoreImpostazioni->incrementaClickSlide($id);
            echo "Dati salvati";
            break;
        case 'incrementaClickColonnaTabellaPrezzi':
            $id = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $gestoreImpostazioni->incrementaClickColonnaTabellaPrezzi($id);
            echo "Dati salvati";
            break;
        case 'incrementaClickBanner':
            $id = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
            $gestoreImpostazioni->incrementaClickBanner($id);
            echo "Dati salvati";
            break;
        case 'disattivaGuidaIniziale':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $geecomDb->eseguiQueryScrittura("UPDATE geecB_impostazioni SET mostraGuidaIniziale='no' WHERE id=1");
            header("Location: $percorsoGeecomCms/home.php");
            break;
        case 'aggiornaImpostazioniApp':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $attivaApp       = filter_input(INPUT_POST,"attivaApp",FILTER_SANITIZE_ADD_SLASHES);
            $nomeCompleto    = filter_input(INPUT_POST,"nomeCompleto",FILTER_SANITIZE_ADD_SLASHES);
            $nomeAbbreviato  = filter_input(INPUT_POST,"nomeAbbreviato",FILTER_SANITIZE_ADD_SLASHES);
            $colore          = filter_input(INPUT_POST,"colore",FILTER_SANITIZE_ADD_SLASHES);
            
            //aggiorno le impostazioni con i dati passati in input
            $queryAggiornamentoImpostazioniApp = "UPDATE geec_impostazioniApp SET attivaApp='$attivaApp', nomeCompleto='$nomeCompleto', nomeAbbreviato='$nomeAbbreviato', colore='$colore' $impostaIcona512 $impostaIcona192 $impostaIcona144 $impostaIcona96 $impostaIcona48 WHERE id=1";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoImpostazioniApp);

            header("Location: $percorsoGeecomCms/impostazioni.php?status=272");
            break;
        case 'svuotaStoricoOperazioni':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $query = "DELETE FROM geec_elementoStoricoOperazioni WHERE prodotto LIKE 'Cms'";
            $geecomDb->eseguiQueryLettura($query);
            header("Location: $percorsoGeecomCms/strumenti/storicoOperazioni/index.php?status=200");
            break;
        case 'disattivaTabellaRiassuntivaHome':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $idComponente = filter_input(INPUT_POST,"idComponente",FILTER_SANITIZE_NUMBER_INT);
            
            $query = "UPDATE geecB_componenti SET tabellaRiassuntivaHome='no' WHERE id=$idComponente";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'attivaTabellaRiassuntivaHome':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $idComponente = filter_input(INPUT_POST,"idComponente",FILTER_SANITIZE_NUMBER_INT);
            
            $query = "UPDATE geecB_componenti SET tabellaRiassuntivaHome='si' WHERE id=$idComponente";
            $geecomDb->eseguiQueryScrittura($query);
            echo "ok";
            break;
        case 'modificaClasseElementiStatisticiPerRigaHomeAdmin':
            controlloAccessoAdmin(); // se l'utente non è loggato reindirizza all'area amministrativa
            $classeElementiStatistici = filter_input(INPUT_POST,"classeElementiStatistici",FILTER_SANITIZE_ADD_SLASHES);
            
            // questo if serve ad evitare che la funzione Javascript che si attiva con l'evento onchange causi l'aggiornamento continuo della pagina
            if($impostazioni["classeElementiStatisticiPerRigaHomeAdmin"]!=$classeElementiStatistici) {
		    $query = "UPDATE geecB_impostazioni SET classeElementiStatisticiPerRigaHomeAdmin='$classeElementiStatistici' WHERE id=1";
		    $geecomDb->eseguiQueryScrittura($query);
		    echo "ok";
            }
            break;
    }
    
    function creaComponente($geecomDb, $idComponente, $idPagina) {
        $datiComponente = $geecomDb->leggiSingolaRiga("geecB_componenti",$idComponente);
        
        if($datiComponente["tipo"]=="componenteDinamicoPagine" && $datiComponente["nome"]!="Visualizzatore galleria" && $datiComponente["tabellaRiferimento"]!="") {
            $datiPagina     = $geecomDb->leggiSingolaRiga("geecB_contenuti",$idPagina);
            $nomeComponente = $geecomDb->escapeString($datiComponente["nome"]);
            $queryInserimento = "INSERT INTO {$datiComponente["tabellaRiferimento"]} (`id`,`nome`) VALUES(NULL,'$nomeComponente pagina {$datiPagina["titolo"]}')";
            return $geecomDb->eseguiQueryCreazione($queryInserimento);            
        }
        else if($datiComponente["nome"]=="Immagine") {
            $immagine = new Immagine($geecomDb, 0, $idPagina, "immagineContenuto");
            return $immagine->crea();
        }
        else {
            return 0;
        }
    }
